package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/12/3 11:50
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskListPageQueryDTO extends PageCommonDTO {
    /**
     * 租户Id
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true,hidden = true)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 任务类型Id集合
     */
    @ApiModelProperty(value = "任务类型Id集合")
    private List<String> taskTypeIdList;

    @ApiModelProperty(value = "任务模版Id")
    private String taskTemplateId;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 0-倒序 1-正序
     */
    private String sortByCreateTime;
}
