package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/10/31 10:28
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskInsertDTO implements Serializable {
    /**
     * 租户id
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    /**
     * 项目id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    @ApiModelProperty(value = "任务Id")
    private String taskId;

    /**
     * 任务类型id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_TYPE_ID_CANNOT_NULL)
    @ApiModelProperty(value = "任务类型id",required = true)
    private String taskTypeId;

    /**
     * 任务模版id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_TEMPLATE_ID_CANNOT_NULL)
    @ApiModelProperty(value = "任务模版id",required = true)
    private String taskTemplateId;

    /**
     * 任务模版名称
     */
    private String taskTemplateName;

    /**
     * 任务名称
     */
    @NotBlank(message = "任务名称不能为空")
    @ApiModelProperty(value = "任务名称",required = true)
    private String taskName;

    /**
     * 任务描述
     */
    @NotBlank(message = "任务描述不能为空")
    @ApiModelProperty(value = "任务描述",required = true)
    private String taskDescription;

    /**
     * 服务供应商id
     */
    @ApiModelProperty(value = "服务供应商id,计划任务需要")
    private String serviceSupplierId;

    /**
     * 需要在岗时间分钟 （固定岗任务需要）
     */
    @ApiModelProperty(value = "在岗时间（固定岗任务必传）")
    private Integer workingMiniute;

    /**
     * 巡视次数（巡视任务需要）
     */
    @ApiModelProperty(value = "巡视次数（巡视任务必传）")
    private Integer patrolCount;

    /**
     * 巡视是否有序（巡视任务需要）
     */
    @ApiModelProperty(value = "巡视是否有序（巡视任务可选）")
    private Integer patrolInOrder;

    /**
     * 巡视是否需要gps定位（巡视任务需要）
     */
    @ApiModelProperty(value = "巡视是否需要gps定位（巡视任务可选）")
    private Integer patrolNeedGps;

    /**
     * 任务周期（1.每日2.每周3.每月第一周4.每月第二周5.每月第三周6.每月第四周）
     */
    @ApiModelProperty(value = "任务周期(巡视任务，固定岗任务，计划任务必传)")
    private Integer taskCycle;

    /**
     * 相关报事报修id
     */
    @ApiModelProperty(value = "报事保修Id(任务从报事生成的必传)")
    private String reportingId;

    @NotBlank(message = PlatformCodeConstants.CREATE_USER_ID_CANNOR_NULL)
    private String createBy;

    @NotBlank(message = PlatformCodeConstants.POSITION_ID_CANNOT_NULL)
    @ApiModelProperty(value = "创建人的岗位id")
    private String createByPositionId;

}
