package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/10/31 10:35
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskExecutorInsertDTO implements Serializable {
    /**
     * 任务执行人岗位id
     */
    @NotBlank(message = PlatformCodeConstants.POSITION_ID_CANNOT_NULL)
    @ApiModelProperty(value = "任务执行岗位Id",required = true)
    private String taskExecutorPositionId;

    /**
     * 任务执行人id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_EXECUTOR_USER_CANNOT_NULL)
    @ApiModelProperty(value = "任务执行人Id",required = true)
    private String taskExecutorUserId;
}
