package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2020/1/16 16:23
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskDetailQueryDTO implements Serializable {

    /**
     * 任务id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_ID_CANNOT_NULL)
    private String taskId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    private String languageCode;
}
