package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/14 13:40
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskAndReportSummeryQueryDTO implements Serializable {

    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 岗位Id
     */
    @ApiModelProperty(value = "岗位Id集合，在点击对应部门统计数据时传")
    private List<String> positionIdList;

    /**
     * 开始日期
     */
    @ApiModelProperty(value = "开始时间")
    private Date startDate;

    /**
     * 结束日期
     */
    @ApiModelProperty(value = "结束时间")
    private Date endDate;

    /**
     * 工单状态
     */
    @ApiModelProperty(value = "工单状态Id,不需要传")
    private String worksheetStatusId;

    /**
     * user id
     */
    private String userId;

    /**
     * 空间id集合
     */
    private List<String> spaceIdList;
}
