package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: fpc
 * @data: 2020/1/4 18:25
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class SingleWorksheetSummeryQueryDTO implements Serializable {
    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 用户Id
     */
    @NotBlank(message = PlatformCodeConstants.USER_ID_CANNOT_BE_EMPTY)
    private String userId;

    /**
     * 工单状态
     */
    @NotBlank(message = PlatformCodeConstants.WORKSHEET_STATUS_CANNOT_NULL)
    private String worksheetStatusId;

    /**
     * 开始时间
     */
    @NotNull(message = PlatformCodeConstants.START_TIME_CANNOT_BE_NULL)
    private Date startDate;

    /**
     * 结束时间
     */
    @NotNull(message =  PlatformCodeConstants.END_TIME_CANNOT_BE_NULL)
    private Date endDate;
}
