package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/12/11 10:12
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class ServiceSupplierQueryDTO implements Serializable {
    /**
     * 租户Id
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 服务提供商Id
     */
    @NotBlank(message = PlatformCodeConstants.SIPPLIER_ID_CANNOT_NULL)
    private String serviceSupplierId;
}
