package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: fpc
 * @data: 2019/10/31 10:50
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class ServiceSupplierInsertDTO implements Serializable {
    /**
     * 租户id
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 0 - 生效 1 - 未生效 2 - 删除
     */
    private String valid;

    /**
     * 服务提供方id
     */
    @ApiModelProperty(value = "服务提供方Id")
    private String serviceSupplierId;

    /**
     * 服务提供方名称
     */
    @ApiModelProperty(value = "服务提供方名称")
    @NotBlank(message = "服务提供方名称不能为空")
    private String serviceSupplierName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建者user_id
     */
    @NotBlank(message = PlatformCodeConstants.OPERATE_USER_ID_CANNOT_NULL)
    private String createBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新者user_id
     */
    private String updateBy;
}
