package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.util.List;

@Data
@ToString(callSuper = true)
public class SeerWorksheetQueryDTO extends PageCommonDTO {

    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;
    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 工单类型
     */
    private List<String> taskTypeList;

    /**
     * 工单状态类型
     */
    private List<String> worksheetStatusId;

    /**
     * 执行人userId
     */
    private String userId;

    /**
     * 执行人岗位Id
     */
    private List<String> positionIdList;

    private String languageCode;


    /**
     * 开始时间
     */
    private Date startDate;

    /**
     * 结束时间
     */
    private Date endDate;

    /**
     * 所有的子级空间
     */
    private List<String> spaceIdList;
}
