package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: fpc
 * @data: 2019/10/31 11:44
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class ReportingUpdateDTO implements Serializable {
    /**
     * 租户id
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    /**
     * 项目id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 报事报修id
     */
    @NotBlank(message = PlatformCodeConstants.REPORT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "报事Id",required = true)
    private String reportingId;

    /**
     * 报事报修标题
     */
    @ApiModelProperty(value = "报事保修标题")
    private String reportingTitle;

    /**
     * 报事报修内容
     */
    @ApiModelProperty(value = "报事保修内容")
    private String reportingContent;

    /**
     * 报事报修空间id
     */
    @ApiModelProperty(value = "报事报修空间Id")
    private String reportingSpaceId;

    /**
     * 状态  0 未处理 1.处理中 2.已处理 3.无需处理
     */
    @ApiModelProperty(value = "状态 0 未处理 1.处理中 2.已处理 3.无需处理")
    private String reportingStatusId;

    /**
     * 创建的临时任务id
     */
    @ApiModelProperty(value = "创建的临时任务Id")
    private String newTaskId;

    /**
     * 创建人user_id
     */
    @ApiModelProperty(value = "创建人userId")
    private String createBy;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 更新者user_id
     */
    @NotBlank(message = PlatformCodeConstants.UPDATE_USER_IS_NULL)
    @ApiModelProperty(value = "更新人userId",required = true)
    private String updateBy;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    /**
     * 拒绝原因
     */
    private String refuseReason;
}
