package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/10/30 14:10
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class ReportingQueryListDTO extends PageCommonDTO {

    /**
     * 状态  0 未处理 1.处理中 2.已处理 3.无需处理
     */
    private String reportingStatusId;

    /**
     * 语言代号
     */
    @NotBlank(message = PlatformCodeConstants.LANGUAGE_CODE_CANNOT_NULL)
    @ApiModelProperty(value = "语言代号",required = true)
    private String languageCode;

    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 报事空间id
     */
    private List<String> reportingSpaceIdList;

    /**
     * 开始时间
     */
    private Date startDate;

    /**
     * 结束时间
     */
    private Date endDate;

    /**
     * 创建人名称
     */
    private String createName;

    /**
     * 创建人用户id集合
     */
    private List<String> userIdList;

    /**
     * 时间排序
     */
    private String sortByCreateTime;
}

