package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/10/30 14:12
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class ReportingQueryDTO implements Serializable {
    /**
     * 报事报修id
     */
    @NotBlank(message = PlatformCodeConstants.REPORT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "报事保修Id",required = true)
    private String reportingId;

    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    @NotBlank(message = PlatformCodeConstants.LANGUAGE_CODE_CANNOT_NULL)
    @ApiModelProperty(value = "语言代号",required = true)
    private String languageCode;
}

