package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/10/30 14:07
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class ReportingInsertDTO implements Serializable {
    /**
     * 租户id
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    /**
     * 项目id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 报事报修标题
     */
    @NotBlank(message = PlatformCodeConstants.REPORT_TITLE_CANNOT_NULL)
    @ApiModelProperty(value = "报事报修标题",required = true)
    private String reportingTitle;

    /**
     * 报事报修内容
     */
    @NotBlank(message = PlatformCodeConstants.REPORT_CONTENT_CANNOT_NULL)
    @ApiModelProperty(value = "报事报修内容",required = true)
    private String reportingContent;

    /**
     * 报事报修空间id
     */
    @NotBlank(message = PlatformCodeConstants.SPACE_ID_CANNOT_NULL)
    @ApiModelProperty(value = "报事报修空间Id内容",required = true)
    private String reportingSpaceId;

    /**
     * 报事图片
     */
    private List<String> pictureList;

    /**
     * 状态  0 未处理 1.处理中 2.已处理 3.无需处理
     */
    private String reportingStatusId;

    /**
     * 创建的临时任务id
     */
    private String newTaskId;

    /**
     * 创建人user_id
     */
    @NotBlank(message = PlatformCodeConstants.CREATE_USER_ID_CANNOR_NULL)
    @ApiModelProperty(value = "创建人userId",required = true)
    private String createBy;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新者user_id
     */
    private String updateBy;

    /**
     * 更新时间
     */
    private Date updateTime;
}
