package com.ifourthwall.dbm.task.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/10/30 14:09
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class ReportingDTO implements Serializable {
    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 报事报修id
     */
    private String reportingId;

    /**
     * 报事报修标题
     */
    private String reportingTitle;

    /**
     * 报事报修内容
     */
    private String reportingContent;

    /**
     * 报事报修空间id
     */
    private String reportingSpaceId;

    /**
     * 状态  0 未处理 1.处理中 2.已处理 3.无需处理
     */
    private String reportingStatusId;

    /**
     * 拒绝原因
     */
    private String refuseReason;

    /**
     * 创建的临时任务id
     */
    private String newTaskId;

    /**
     * 创建人user_id
     */
    private String createBy;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新者user_id
     */
    private String updateBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 状态编码
     */
    private String reportingStatusTranslationContentCode;

    /**
     * 内容翻译值
     */
    private String contentValue;

    private List<ReportingPictureDTO> pictureList;

    private String worksheetNo;

    private String taskWorksheetId;
}
