package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: fpc
 * @data: 2019/11/14 13:43
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class ReportSummeryQueryDTO implements Serializable {
    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 开始时间
     */
    @NotNull(message =  PlatformCodeConstants.START_TIME_CANNOT_BE_NULL)
    @ApiModelProperty(value = "开始时间",required = true)
    private Date startDate;

    /**
     * 结束时间
     */
    @NotNull(message = PlatformCodeConstants.END_TIME_CANNOT_BE_NULL)
    @ApiModelProperty(value = "结束时间",required = true)
    private Date endDate;

    /**
     * 创建人userId
     */
    private String userId;
}
