package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2020/4/28 15:11
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryWorksheetByTaskIdDTO implements Serializable {

    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @NotEmpty(message = PlatformCodeConstants.TASK_ID_CANNOT_NULL)
    private List<String> taskIdList;
}
