package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2020/5/21 11:52
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryDailyOfflinePackageDTO implements Serializable {

    /**
     * 执行人userId
     */
    @NotBlank(message = PlatformCodeConstants.USER_ID_CANNOT_BE_EMPTY)
    private String userId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 租户Id
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 主语岗位Id集合
     */
    @NotEmpty(message = PlatformCodeConstants.POSITION_ID_CANNOT_NULL)
    private List<String> permissionSubjectPositionIdList;
}
