package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2020/4/20 10:18
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryCheckpointRelationByIdDTO implements Serializable {

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 点位id
     */
    @NotEmpty(message = PlatformCodeConstants.CHECKPOINT_ID_LIST_CANNOT_NULL)
    private List<String> checkpointId;
}
