package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: fpc
 * @data: 2019/11/28 16:02
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PlanTaskValidTimeDTO implements Serializable {
    /**
     * 计划任务Id
     */
    @ApiModelProperty(value = "计划任务Id",hidden = true)
    private String planTaskId;

    /**
     * 工单生效时间
     */
    @NotNull(message = PlatformCodeConstants.VALID_TIEM_CANNOT_NULL)
    @ApiModelProperty(value = "工单生效时间",required = true)
    private Date validTime;
}
