package com.ifourthwall.dbm.task.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/29 10:56
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PlanTaskDetailDTO implements Serializable {
    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 任务id
     */
    private String taskId;

    /**
     * 是否有效  0 - 生效 1 - 未生效 2 - 删除
     */
    private String valid;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 任务类型id
     */
    private String taskTypeId;

    /**
     * 任务模版id
     */
    private String taskTemplateId;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 任务描述
     */
    private String taskDescription;

    /**
     * 服务供应商id
     */
    private String serviceSupplierId;

    /**
     * 服务提供方名称
     */
    private String serviceSupplierName;

    /**
     * 需要在岗时间分钟 （固定岗任务需要）
     */
    private Integer workingMiniute;

    /**
     * 巡视次数（巡视任务需要）
     */
    private Integer patrolCount;

    /**
     * 巡视是否有序（巡视任务需要）
     */
    private Integer patrolInOrder;

    /**
     * 巡视是否需要gps定位（巡视任务需要）
     */
    private Integer patrolNeedGps;

    /**
     * 任务周期（1.每日2.每周3.每月）
     */
    private Integer taskCycle;

    /**
     * 相关报事报修id
     */
    private String reportingId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建人user_id
     */
    private String createBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人user_id
     */
    private String updateBy;


    /**
     * 任务的执行人信息
     */
    private List<TaskExecutorDTO> taskExecutorList;

    /**
     * 任务工单信息
     */
    List<TaskWorksheetDTO> taskWorksheetDTOList;

    /**
     * 任务空间信息
     */
    List<TaskSpaceInsertDTO> taskSpaceInsertDTOList;

    /**
     * 计划任务工单生成时间
     */
    List<PlanTaskValidTimeDTO> planTaskValidTimeDTOList;
}
