package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/10/31 14:22
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PlanTaskCategoryTagUpdateDTO implements Serializable {
    /**
     * 计划任务目录标签id
     */
    @NotBlank(message = PlatformCodeConstants.PPM_CATRGORY_TAG_ID_CANNOT_NULL)
    @ApiModelProperty(value = "计划任务目录标签Id",required = true)
    private String planTaskCategoryTagId;

    /**
     * 计划任务目录标签名称
     */
    @NotBlank(message = PlatformCodeConstants.PPM_CATEGORY_TAG_NAME_CANNOT_NULL)
    @ApiModelProperty(value = "计划任务目录标签名称",required = true)
    private String planTaskCategoryTagName;


    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户Id",required = true)
    private String tenantId;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新者user_id
     */
    @NotBlank(message = PlatformCodeConstants.UPDATE_USER_IS_NULL)
    @ApiModelProperty(value = "更新人userId",required = true)
    private String updateBy;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 岗位集合Id
     */
    @NotEmpty(message = PlatformCodeConstants.POSITION_ID_CANNOT_NULL)
    @ApiModelProperty(value = "岗位Id",required = true)
    private List<String> permissionSubjectPositionIdList;
}
