package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/10/31 14:20
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PlanTaskCategoryTagQueryDTO implements Serializable {
    /**
     * 计划任务目录标签id
     */

    @NotBlank(message = PlatformCodeConstants.PPM_CATRGORY_TAG_ID_CANNOT_NULL)
    @ApiModelProperty(value = "计划任务目录标签Id",required = true)
    private String planTaskCategoryTagId;

    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户Id",required = true)
    private String tenantId;


    @NotBlank(message = PlatformCodeConstants.TAG_TYPE_CANNOT_NULL)
    @ApiModelProperty(value = "计划任务目录标签类型 1-maintenance 2-system",required = true)
    private String tagType;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 岗位集合Id
     */
    @NotEmpty(message = PlatformCodeConstants.POSITION_ID_CANNOT_NULL)
    @ApiModelProperty(value = "岗位集合Id",required = true)
    private List<String> permissionSubjectPositionIdList;

    @NotBlank(message = PlatformCodeConstants.OPERATOR_ID_CANNOT_NULL)
    @ApiModelProperty(value = "操作人userId",required = true)
    private String updateBy;
}
