package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/10/31 14:15
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PlanTaskCategoryTagInsertDTO implements Serializable {
    /**
     * 租户id
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户Id",required = true)
    private String tenantId;


    /**
     * 0 - 生效 1 - 未生效 2 - 删除
     */
    private String valid;

    /**
     * 计划任务目录标签id
     */
    private String planTaskCategoryTagId;

    /**
     * 计划任务目录标签名称
     */
    @NotBlank(message = PlatformCodeConstants.PPM_CATEGORY_TAG_NAME_CANNOT_NULL)
    @ApiModelProperty(value = "计划任务目录标签名称",required = true)
    private String planTaskCategoryTagName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建者user_id

     */
    @NotBlank(message = PlatformCodeConstants.CREATE_USER_ID_CANNOR_NULL)
    @ApiModelProperty(value = "创建者userId",required = true)
    private String createBy;

    /**
     * 更新时间

     */
    private Date updateTime;

    /**
     * 更新者user_id
     */
    private String updateBy;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 岗位集合Id
     */
    @NotEmpty(message = PlatformCodeConstants.POSITION_ID_CANNOT_NULL)
    @ApiModelProperty(value = "岗位集合Id",required = true)
    private List<String> permissionSubjectPositionIdList;
}
