package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/10/31 17:47
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PlanTaskCategoryRelationInsertDTO implements Serializable {
    /**
     * 计划任务目录id
     */
    @NotBlank(message = PlatformCodeConstants.PPM_CATEGPRY_ID_CANNOT_NULL)
    @ApiModelProperty(value = "计划任务目录Id",required = true)
    private String planTaskCategoryId;

    /**
     * 计划任务保养类型标签id
     */
    @NotBlank(message = PlatformCodeConstants.PPM_MAINTENANCE_TAG_ID_CANNOT_NULL)
    @ApiModelProperty(value = "计划任务保养类型标签Id",required = true)
    private String planTaskMaintenanceTagId;

    /**
     * 计划任务系统标签id
     */
    @NotBlank(message = PlatformCodeConstants.PPM_SYSTEM_TAG_ID_CANNOT_NULL)
    @ApiModelProperty(value = "计划任务系统标签Id",required = true)
    private String planTaskSystemTagId;

    @NotNull(message = PlatformCodeConstants.TASK_DETAIL_INFO_CANNOT_NULL)
    @ApiModelProperty(value = "任务详细信息",required = true)
    private TaskWrapInsertDTO taskWrap;

    /**
     * 计划任务id
     */
    @ApiModelProperty(value = "计划任务子任务Id(创建时不需要传)")
    private String planTaskId;

    private List<String> positionIdList;

    @ApiModelProperty(value = "计划任务工单生产时间集合")
    private List<PlanTaskValidTimeDTO> planTaskValidTimeList;
}
