package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/10/30 15:33
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PlanTaskCategoryOperateDTO implements Serializable {
    /**
     * 计划任务目录id
     */
    @NotBlank(message = PlatformCodeConstants.PPM_CATEGPRY_ID_CANNOT_NULL)
    @ApiModelProperty(value = "计划任务目录Id",required = true)
    private String planTaskCategoryId;

    /**
     * 0 - 生效 1 - 未生效 2 - 删除
     */
    @NotBlank(message = PlatformCodeConstants.TASK_OPERATE_TYPE_CANNOT_NULL)
    @ApiModelProperty(value = "操作类型0-生效（启用） 1-失效（停用） 2-删除（删除）",required = true)
    private String valid;

    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户Id",required = true)
    private String tenantId;

    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    @NotBlank(message = PlatformCodeConstants.OPERATOR_ID_CANNOT_NULL)
    @ApiModelProperty(value = "操作人userId",required = true,hidden = true)
    private String updateBy;

    /**
     * 上一次启用时间
     */
    private Date lastValidTime;

    /**
     * 上一次停用时间
     */
    private Date lastInvalidTime;

    @NotEmpty(message = PlatformCodeConstants.POSITION_ID_CANNOT_NULL)
    @ApiModelProperty(value = "岗位Id集合",required = true)
    private List<String> permissionSubjectPositionIdList;

}
