package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/10/30 15:40
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PlanTaskCategoryListQueryDTO implements Serializable {
    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 项目id
     */
    private String projectId;

    private String planTaskCategoryYear;

    private String planTaskCategoryId;


    @NotEmpty(message = PlatformCodeConstants.USER_POSITION_LIST_CANNOT_NULL)
    private List<String> permissionSubjectPositionIdList;

}
