package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/10/30 15:30
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PlanTaskCategoryInsertDTO implements Serializable {
    /**
     * 租户id
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 计划任务目录id
     */
    private String planTaskCategoryId;

    /**
     * 0 - 生效 1 - 未生效 2 - 删除
     */
    private String valid;

    /**
     * 计划任务目录名称
     */
    @NotBlank(message = PlatformCodeConstants.PPM_CATEGORY_NAME_CANNOT_NULL)
    private String planTaskCategoryName;

    /**
     * 计划任务目录年份
     */
    @NotBlank(message = PlatformCodeConstants.PPM_CATEGORY_YEAY_CANNOT_NULL)
    private String planTaskCategoryYear;

    /**
     * 项目id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 上一次启用时间
     */
    private Date lastValidTime;

    /**
     * 上一次停用时间
     */
    private Date lastInvalidTime;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建者user_id
     */
    @NotBlank(message = PlatformCodeConstants.CREATE_USER_ID_CANNOR_NULL)
    private String createBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新者user_id
     */
    private String updateBy;

    @NotEmpty(message = PlatformCodeConstants.CREATOR_POSITION_ID_CANNOT_NULL)
    private List<String> permissionSubjectPositionIdList;

}
