package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/1 14:23
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PlanTaskCategoryDetailQueryDTO implements Serializable {

    @ApiModelProperty(value = "租户号",required = true)
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    @ApiModelProperty(value = "项目Id",required = true)
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;


    @ApiModelProperty(value = "计划任务目录Id",required = true)
    @NotBlank(message = PlatformCodeConstants.PPM_CATEGPRY_ID_CANNOT_NULL)
    private String planTaskCategoryId;

    @ApiModelProperty(value = "计划任务主标签Id")
    private String planTaskMaintenanceTagId;

    private String planTaskSystemTagId;


    @NotEmpty(message = PlatformCodeConstants.POSITION_ID_CANNOT_NULL)
    @ApiModelProperty(value = "岗位id集合",required = true)
    private List<String> permissionSubjectPositionIdList;

}
