package com.ifourthwall.dbm.task.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: fpc
 * @data: 2019/10/30 15:39
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PlanTaskCategoryDTO implements Serializable {
    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 计划任务目录id
     */
    private String planTaskCategoryId;

    /**
     * 0 - 生效 1 - 未生效 2 - 删除
     */
    private String valid;

    /**
     * 计划任务目录名称
     */
    private String planTaskCategoryName;

    /**
     * 计划任务目录年份
     */
    private String planTaskCategoryYear;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 上一次启用时间
     */
    private Date lastValidTime;

    /**
     * 上一次停用时间
     */
    private Date lastInvalidTime;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建者user_id
     */
    private String createBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新者user_id
     */
    private String updateBy;

    /**
     * 总工单数量
     */
    private Integer totalWorksheetNum;

    /**
     * 完成的工单数量
     */
    private Integer finishWorksheetNum;
}
