package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/8 13:26
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class OperationTempWorksheetListQueryDTO extends PageCommonDTO {
    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 任务基本类型 1-临时任务 2-固定任务 3-巡视任务 4-计划任务
     */
    @NotEmpty(message = PlatformCodeConstants.TASK_TYPE_ID_CANNOT_NULL)
    @ApiModelProperty(value = "任务基本类型集合（1-临时任务 2-固定任务 3-巡视任务 4-计划任务）",required = true)
    private List<String> taskTypeIdList;

    /**
     * 主语岗位Id
     */
    @ApiModelProperty(value = "主语岗位集合")
    private List<String> permissionSubjectPositionIdList;

    /**
     * 权限任务操作id 1-发布临时任务 2-查询他人任务 3-委派他人任务 4-升级他人任务 5-分享他人任务 6-标签修改删除 7-内容修改 8-执行任务 9-特殊任务执行
     * 10-抢单 11-反馈他人任务 12-发布固定任务 13-执行固定任务 14-查询固定任务 15-发布巡视任务 16-查询巡视任务 17-执行巡视任务
     *
     *
     * 查询-2 抢单-10
     */
    @ApiModelProperty(value = "操作类型")
    private String permissionTaskOperationId;


    /**
     * 工单状态
     */
    @ApiModelProperty(value = "工单状态集合")
    private List<String> worksheetStatusIdList;

    /**
     * 任务模板id
     */
    @ApiModelProperty(value = "任务模版Id")
    private String taskTemplateId;

    /**
     * 和我相关 0 - 是 1 - 否
     */
    @ApiModelProperty(value = "是否和我相关")
    private String isRelativeToMe;

    /**
     * 用户userId
     */
    @ApiModelProperty(value = "用户userId,当筛选条件为和我相关时必传")
    private String userId;


//    /**
//     * 可以查询发布人的userid集合
//     */
//    @NotEmpty(message = "可查询发布人userId信息不能为空")
//    @ApiModelProperty(value = "可以查询发布人的userid集合",required = true)
//    private List<String> createUserIdList;

    /**
     * 创建人userId集合
     */
    private List<String> createUserIdList;

    /**
     * 工单号
     */
    private String worksheetNo;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 开始时间
     */
    private Date startDate;

    /**
     * 结束时间
     */
    private Date endDate;

    /**
     * 0.是我创建
     */
    private String createByMe;


    /**
     * 1.创建时间 2.更新时间
     */
    private String queryType;

    /**
     * 0-超时 1-未超时
     */
    private String isExpire;

    /**
     * 当前日期
     */
    private Date currentDate;

    /**
     * 0-已完成 1-未完成
     */
    private String isFinished;
}
