package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2020/6/16 11:03
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class MeterInfoDTO implements Serializable {

    @NotBlank(message = PlatformCodeConstants.TRACKER_METER_DATAPOINT_ID_CANNOT_NULL)
    private String dataPointId;

    @NotBlank(message = PlatformCodeConstants.TRACKER_METER_DATAPOINT_VALUE_CANNOT_NULL)
    private String value;

    @NotBlank(message = PlatformCodeConstants.TRACKER_METER_DEVICE_ID_CANNOT_NULL)
    private String deviceId;

    @NotBlank(message = PlatformCodeConstants.USER_INFO_IS_NULL)
    private String userName;

    @NotBlank(message = PlatformCodeConstants.USER_ID_CANNOT_BE_EMPTY)
    private String userId;
}
