package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.util.List;

@Data
@ToString(callSuper = true)
public class ExportTemporaryWorksheetQueryDTO extends PageCommonDTO {

    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 租户id
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 语言编码
     */
    private String languageCode;

    /**
     * 开始时间
     */
    private Date startDate;

    /**
     * 结束时间
     */
    private Date endDate;

    /**
     * 1.按发布时间 2.按完成时间
     */
    private String queryType;

    /**
     * 空间名称
     */
    private String spaceName;

    /**
     * 空任务模板id
     */
    private String taskTemplateId;

    /**
     * 任务末班标签id
     */
    private String taskTemplateTagId;

    /**
     * 执行岗位Id集合
     */
    private List<String> executePositionIdList;

    /**
     * 创建人岗位Id集合
     */
    private List<String> createUserIdList;

    /**
     * 执行人用户Id集合
     */
    private List<String> executeUserIdList;

    /**
     * 工单状态Id集合
     */
    private List<String> worksheetStatusIdList;

    /**
     * 任务类型集合
     */
    private List<String> taskTypeIdList;
}
