package com.ifourthwall.dbm.task.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
@ToString(callSuper = true)
public class ExportTemporaryWorksheetDTO implements Serializable {

    /**
     * 工单id
     */
    private String taskWorksheetId;

    /**
     * 工单号
     */
    private String worksheetNo;

    /**
     * 工单状态
     */
    private String worksheetStatusId;

    /**
     * 工单标签名称
     */
    private String taskTemplateTagName;


    /**
     * 特殊状态标志
     */
    private String specicalFlag;

    /**
     * 反馈标志
     */
    private String feedbackFlag;

    /**
     * 过期标志
     */
    private String expiredFlag;
    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建者user_id
     */
    private String createBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 过期时间
     */
    private Date expireTime;

    /**
     * 任务类型
     */
    private String taskTypeId;

    /**
     * 更新者user_id
     */
    private String updateBy;

    /**
     * 任务名称
     */
    private String taskName;
    /**
     * 任务模板id
     */
    private String taskTemplateId;
    /**
     * 任务模版名称
     */
    private String taskTemplateName;

    /**
     * 反馈星级
     */
    private String worksheetEventResult;

    /**
     * 反馈备注
     */
    private String worksheetEventContent;

    /**
     * 工单状态名称
     */
    private String worksheetStatusName;

    /**
     * 任务空间名称
     */
    private List<TaskSpaceInsertDTO> taskSpaceList;

    /**
     * 执行人信息
     */
    private List<WorksheetExecutorDTO> executorList;

}
