package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.util.List;

@Data
@ToString(callSuper = true)
public class ExportDailyWorksheetQueryDTO extends PageCommonDTO {

    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 任务类型 2.固定任务 3.巡视任务
     */
    private String taskTypeId;

    /**
     * 任务周期 1.每日 2.每周 3.每月
     */
    private String taskCycle;

    /**
     * 开始时间
     */
    private Date startDate;

    /**
     * 结束时间
     */
    private Date endDate;

    /**
     * 执行人集合
     */
    private List<String> userIdList;
}
