package com.ifourthwall.dbm.task.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: fpc
 * @data: 2019/11/6 15:38
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class EventConsumptionDTO implements Serializable {
    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 工单事件id
     */
    private String worksheetEventId;

    /**
     * 消耗类型 1 物料消耗 2 金额备注
     */
    private String consumptionType;

    /**
     * 消耗品名称
     */
    private String consumptionName;

    /**
     * 消耗品价格
     */
    private BigDecimal price;

    /**
     * 备注
     */
    private String remark;

    /**
     * 支付时间
     */
    private Date payTime;
}
