package com.ifourthwall.dbm.task.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/9 13:50
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class DailyTaskWorkSheetWrapDTO implements Serializable {

    /**
     * 工单基本信息
     */
    private TaskWorksheetDTO taskWorksheetDTO;

    /**
     * 工单对应任务的基本信息
     */
    private TaskInsertDTO taskInsertDTO;

    /**
     * 工单对应任务的图片信息
     */
    private List<TaskPictureInsertDTO> taskPictureInsertDTOList;

    /**
     * 任务执行人的相关信息
     */
    private List<WorksheetExecutorDTO> worksheetExecutorDTOList;

    /**
     * 该工单需要扫描的蓝牙点位的信息
     */
    private List<TaskCheckPointRelationInsertDTO> taskCheckPointRelationInsertDTOList;

    /**
     * 工单对应的扫描基本信息
     */
    List<ScanInfoDTO> scanInfoDTOList;
}
