package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/2 15:25
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class DailyTaskWorkSheetListQueryDTO extends PageCommonDTO {

    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 任务类型 2-固定任务 3-巡视任务
     */
    @NotBlank(message = PlatformCodeConstants.TASK_TYPE_ID_CANNOT_NULL)
    @ApiModelProperty(value = "任务类型 2-固定任务 3-巡视任务",required = true)
    private String taskTypeId;

    @NotEmpty(message = PlatformCodeConstants.POSITION_ID_CANNOT_NULL)
    @ApiModelProperty(value = "用户岗位Id",required = true)
    private List<String> permissionSubjectPositionIdList;

    /**
     * 任务模版Id
     */
    @ApiModelProperty(value = "任务模版Id(筛选条件)")
    private String taskTemplateId;

    /**
     * 查询日期
     */
    @ApiModelProperty(value = "查询日期（筛选条件）")
    private Date currentDate;

    /**
     * 任务名称
     */
    @ApiModelProperty(value = "任务名称(筛选条件)")
    private String taskName;

    /**
     * 1-每日 2-每周 3-每月
     */
    @ApiModelProperty(value = "任务周期（巡视任务工单筛选条件 1-每日 2-每周 3-每月）")
    private Integer taskCycle;

    /**
     * 任务周期为每周时，传第几周
     */
    @ApiModelProperty(value = "周数（第几周）筛选条件为 按周查看时传")
    private Integer weekNo;

    @ApiModelProperty(value = "月（第几月）筛选条件为 按月查看时传")
    private Integer monthNo;

    /**
     * 哪一年（任务周期为 周 和 月时需要）
     */
    @ApiModelProperty(value = "第几年，筛选条件为周和月时查看")
    private Integer year;
}
