package com.ifourthwall.dbm.task.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/2 15:27
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class DailyTaskWorkSheetListDTO implements Serializable {

    /**
     * 租户Id
     */
    private String tenantId;

    /**
     * 项目Id
     */
    private String projectId;

    /**
     * 任务Id
     */
    private String taskId;

    /**
     * 任务类型
     */
    private String taskTypeId;

    /**
     * 工单id
     */
    private String taskWorksheetId;

    /**
     * 工单号
     */
    private String worksheetNo;

    /**
     * 工单状态
     */
    private String worksheetStatusId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建者user_id
     */
    private String createBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新者user_id
     */
    private String updateBy;

    /**
     * 过期时间
     */
    private Date expireTime;

    /**
     * 任务名称
     */
    private String taskName;
    /**
     * 任务描述
     */
    private String taskDescription;
    /**
     * 任务模板id
     */
    private String taskTemplateId;
    /**
     * 任务模版名称
     */
    private String taskTemplateName;

    /**
     * 需要巡视的次数
     */
    private int patrolCount;

    /**
     * 实际巡视次数
     */
    private int patrolCountActual;

    /**
     * 需要在岗时间
     */
    private int workingMiniute;

    /**
     * 实际在岗时间
     */
    private int workingMinuteActual;

    /**
     * 是否按顺序巡点
     */
    private Integer patrolInOrder;

    /**
     * 任务执行人
     */
    private List<WorksheetExecutorDTO> worksheetExecutorList;

    /**
     * 点位信息
     */
    private List<TaskCheckPointRelationInsertDTO> taskCheckPointRelationList;
}
