package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
@ToString(callSuper = true)
public class CheckpointScanOutlineQueryDTO implements Serializable {

    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @NotEmpty(message = PlatformCodeConstants.CHECKPOINT_ID_LIST_CANNOT_NULL)
    private List<String> checkpointIdList;

    /**
     * 日期
     */
    private Date date;
}
