package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/11/9 13:56
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class CheckPointScanInfoQueryDTO implements Serializable {
    /**
     * 任务工单id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_WORKSHEET_ID_CANNOT_NULL)
    @ApiModelProperty(value = "任务工单Id",required = true)
    private String taskWorksheetId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    /**
     * 创建人userId
     */
    @NotBlank(message = PlatformCodeConstants.OPERATE_USER_ID_CANNOT_NULL)
    @ApiModelProperty(value = "巡视人员userId",required = true)
    private String createBy;

    /**
     * 扫描路线次数编号
     */
    @NotBlank(message = "扫描次数编号不能为空")
    @ApiModelProperty(value = "扫描编号",required = true)
    private String scanRouteUuid;

}
