package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/12/11 15:03
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class CheckPointQueryDTO implements Serializable {
    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * checkPointId
     */
    @NotBlank(message = PlatformCodeConstants.CHECKPOINT_ID_LIST_CANNOT_NULL)
    private String checkPointId;
}
