package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;

/**
 * @author: fpc
 * @data: 2020/4/26 19:45
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class AssetWorksheetQueryDTO extends PageCommonDTO {

    /**
     * 租户id
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 项目id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 资产id
     */
    @NotBlank(message = PlatformCodeConstants.ASSET_ID_CANNOT_NULL)
    private String assetId;

    private String languageCode;
}
