package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/11/6 15:40
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class AssetCheckRecordDTO implements Serializable {
    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 资产检查记录id
     */
    private String assetCheckRecordId;

    /**
     * 资产id
     */
    @NotBlank(message = PlatformCodeConstants.ASSET_ID_CANNOT_NULL)
    @ApiModelProperty(value = "资产Id",required = true)
    private String assetId;

    /**
     * 检查点id
     */
    private String checkpointId;

    /**
     * 工单事件id
     */
    private String worksheetEventId;

    /**
     * 资产状态
     */
    @NotBlank(message = "资产状态不能为空")
    @ApiModelProperty(value = "资产状态0-好 1坏",required = true)
    private String assetStatus;

    /**
     * 新临时任务id
     */
    private String newTaskId;

    /**
     * 新生成的临时任务名称
     */
    private String taskName;

    private String taskWorksheetId;


    /**
     * 创建任务需要信息
     */
    @ApiModelProperty(value = "创建任务信息,当该资产状态为坏的时候，必传")
    private TaskWrapInsertDTO taskWrap;
}
