package com.ifourthwall.dbm.provider.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.provider.dto.member.*;

/**
 * @Author: YangPeng
 * @Date: 2020/10/9 17:44
 * @Description:
 */
public interface ResidenceMemberFacade {

    /**
     * 新增住户人员
     * @Author: YangPeng
     * @Date: 2020/10/9 17:45
     * @param insertMember
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertResidenceMember(InsertResidenceMemberDTO insertMember);

    /**
     * 修改住户人员
     * @Author: YangPeng
     * @Date: 2020/10/10 14:23
     * @param upEmployee
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse updateResidenceMember(UpdateResidenceMemberDTO upEmployee);

    /**
     * 查询住户人员列表
     * @Author: YangPeng
     * @Date: 2020/10/10 15:06
     * @param queryPage
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.provider.dto.member.QueryResidenceMemberPageDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryResidenceMemberPageDTO>> queryResidenceMemberPage(QueryResidenceMemberPageQuDTO queryPage);

    /**
     * 删除住户人员
     *
     * @param delete
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/10/10 15:22
     */
    BaseResponse deleteResidenceMember(DeleteResidenceMemberDTO delete);
}
