package com.ifourthwall.dbm.provider.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.provider.dto.residence.*;
import com.ifourthwall.dbm.provider.dto.space.QuerySpaceListDTO;
import com.ifourthwall.dbm.provider.dto.space.QuerySpaceListQuDTO;

/**
 * @Author: YangPeng
 * @Date: 2020/9/10 09:41
 * @Description:
 */
public interface EstateResidenceFacade {

    /**
     * 新增住户
     * @Author: YangPeng
     * @Date: 2020/9/10 9:42
     * @param insert
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse<InsertResidenceReDTO> insertResidence(InsertResidenceDTO insert);

    /**
     * 修改住户
     * @Author: YangPeng
     * @Date: 2020/9/10 14:55
     * @param upResidence
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse updateResidence(UpdateResidenceDTO upResidence);

    /**
     * 查询住户列表
     * @Author: YangPeng
     * @Date: 2020/9/11 14:40
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.provider.dto.residence.ResidencePageDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<ResidencePageDTO>> queryResidencePage(QueryResidencePageDTO query);

    /**
     * 查询住户详情
     * @Author: YangPeng
     * @Date: 2020/9/14 11:22
     * @param queryInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.provider.dto.residence.QueryResidenceInfoDTO>
     * @throws
     */
    BaseResponse<QueryResidenceInfoDTO> queryResidenceInfo(QueryResidenceInfoQuDTO queryInfo);

    /**
     * 根据项目查看项目已选空间
     * @Author: YangPeng
     * @Date: 2020/9/14 15:05
     * @param queryInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.provider.dto.space.QuerySpaceListDTO>
     * @throws
     */
    BaseResponse<QuerySpaceListDTO> querySpaceList(QuerySpaceListQuDTO queryInfo);

    /**
     * 新增住户附件
     * @Author: YangPeng
     * @Date: 2020/11/4 10:05
     * @param insert
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertResidenceAnnex(InsertResidenceAnnexDTO insert);

    /**
     * 修改住户附件
     * @Author: YangPeng
     * @Date: 2020/11/4 10:11
     * @param upResidence
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse updateResidenceAnnex(UpdateResidenceAnnexDTO upResidence);

    /**
     * 查询住户附件
     * @Author: YangPeng
     * @Date: 2020/11/4 10:12
     * @param queryInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.provider.dto.residence.QueryResidenceAnnexDTO>
     * @throws
     */
    BaseResponse<QueryResidenceAnnexDTO> queryResidenceAnnex(QueryResidenceAnnexQuDTO queryInfo);

    /**
     * 查询住户详情(基础)
     * @Author: YangPeng
     * @Date: 2020/12/21 15:14
     * @param queryInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.provider.dto.residence.QueryResidenceBasisInfoDTO>
     * @throws
     */
    BaseResponse<QueryResidenceBasisInfoDTO> queryResidenceBasisInfo(QueryResidenceInfoBasisQuDTO queryInfo);
}
