package com.ifourthwall.dbm.provider.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.provider.dto.announcement.*;

/**
 * @Author: YangPeng
 * @Date: 2020/10/26 15:05
 * @Description:
 */
public interface EstatePropertyFacade {

    /**
     * 创建物业公告
     *
     * @param insert
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/10/26 14:55
     */
    BaseResponse insertMerchant(InsertAnnouncementDTO insert);

    /**
     * 编辑物业公告
     *
     * @param update
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/10/26 15:03
     */
    BaseResponse updateAnnouncement(UpdateAnnouncementDTO update);

    /**
     * 启用停用公告
     * @Author: YangPeng
     * @Date: 2020/10/26 17:08
     * @param enableOrDeactivate
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse enableOrDeactivate(EnableOrDeactivateDTO enableOrDeactivate);

    /**
     * 查询物业公告列表
     * @Author: YangPeng
     * @Date: 2020/10/26 17:31
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.provider.dto.announcement.QueryAnnouncementListDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryAnnouncementListDTO>> queryAnnouncementList(QueryAnnouncementListQuDTO query);

    /**
     * 删除物业公告
     * @Author: YangPeng
     * @Date: 2020/10/27 14:15
     * @param delete
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse deleteAnnouncement(DeleteAnnouncementDTO delete);

    /**
     * 查询表扬物业列表
     * @Author: YangPeng
     * @Date: 2020/10/27 14:52
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.provider.dto.announcement.QueryPraiseListDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryPraiseListDTO>> queryPraiseList(QueryPraiseListQuDTO query);

    /**
     * 查询表扬物业详情
     * @Author: YangPeng
     * @Date: 2020/10/27 14:52
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.provider.dto.announcement.QueryPraiseInfoDTO>
     * @throws
     */
    BaseResponse<QueryPraiseInfoDTO> queryPraiseInfo(QueryPraiseInfoQuDTO query);

    /**
     * WX物业公告列表
     * @Author: YangPeng
     * @Date: 2020/12/21 9:50
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.provider.dto.announcement.QueryAnnouncementListDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryAnnouncementListDTO>> queryWxAnnouncementList(QueryWxAnnouncementListQuDTO query);

    /**
     * WX物业公告详情
     * @Author: YangPeng
     * @Date: 2020/12/21 11:43
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.provider.dto.announcement.QueryAnnouncementListDTO>
     * @throws
     */
    BaseResponse<QueryAnnouncementListDTO> queryWxAnnouncementInfo(QueryWxAnnouncementInfoQuDTO query);

    /**
     * WX创建表扬物业
     * @Author: YangPeng
     * @Date: 2020/12/21 16:20
     * @param insertPropertyPraiseQuDTO
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertPropertyPraise(InsertPropertyPraiseQuDTO insertPropertyPraiseQuDTO);

    /**
     * 表扬物业列表
     * @Author: YangPeng
     * @Date: 2020/12/22 14:17
     * @param queryWxPropertyPraise
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.provider.dto.announcement.QueryWxPropertyPraisePageDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryWxPropertyPraisePageDTO>> queryWxPropertyPraisePage(QueryWxPropertyPraisePageQuDTO queryWxPropertyPraise);

    /**
     * 表扬物业详情
     * @Author: YangPeng
     * @Date: 2020/12/22 14:17
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.provider.dto.announcement.QueryWxPropertyPraiseInfoDTO>
     * @throws
     */
    BaseResponse<QueryWxPropertyPraiseInfoDTO> queryWxPropertyPraiseInfo(QueryWxPropertyPraiseInfoQuDTO query);
}
