package com.ifourthwall.dbm.provider.dto.user;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;

/**
 * @Author: YangPeng
 * @Date: 2020/11/16 14:40
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class SelectEstateNameQuDTO extends BaseReqDTO {

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("不动产名称")
    private String estateName;

    @ApiModelProperty("不动产类型 1.商户 2.住户")
    private String estateType;
}
