package com.ifourthwall.dbm.provider.dto.user;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/11/23 10:04
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryUserModeInfoDTO implements Serializable {

    @ApiModelProperty("userId")
    private String userId;

    @ApiModelProperty("商户Id")
    private String merchantId;

    @ApiModelProperty("住户id")
    private String residenceId;

    @ApiModelProperty("租户id")
    private String tenantId;

    @ApiModelProperty("该用户的权限url")
    private List<String> urls;

    @ApiModelProperty("不动产id")
    private String estateId;

    @ApiModelProperty("不动产类别（1.商户 2.住户）")
    private String estateCategory;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("商住户人员id")
    private String estateMerchantOrResidenceId;

    @ApiModelProperty("人员身份类型 1.管理员 2.普通员工 3.游客")
    private String userType;

    @ApiModelProperty("人员手机号")
    private String phone;
}
