package com.ifourthwall.dbm.provider.dto.user;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

/**
 * @Author: YangPeng
 * @Date: 2020/11/9 14:07
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryEstateNameByUserIdQuDTO implements Serializable {

    @ApiModelProperty("用户id")
    @NotEmpty(message = PlatformCodeConstants.USER_ID_CANNOT_BE_EMPTY)
    private String userId;

    @ApiModelProperty("不动产id")
    @NotEmpty(message = PlatformCodeConstants.ESTATE_ID_NOT_NULL)
    private String estateId;

}
