package com.ifourthwall.dbm.provider.dto.space;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/11/16 14:45
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryEstateSpaceQuDTO implements Serializable {

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("不动产id")
    @NotEmpty(message = PlatformCodeConstants.ESTATE_ID_NOT_NULL)
    private String estateId;
}
